/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsSubscriptionInformations extends JavaScriptObject {

	protected JsSubscriptionInformations() {}

	public final native String getVersion()
	/*-{
	return this["version"];
	}-*/;

	public final native void setVersion(String version)
	/*-{
       this["version"] = version;
	}-*/;

	public final native String getInstallationVersion()
	/*-{
	return this["installationVersion"];
	}-*/;

	public final native void setInstallationVersion(String installationVersion)
	/*-{
       this["installationVersion"] = installationVersion;
	}-*/;

	public final native String getCustomer()
	/*-{
	return this["customer"];
	}-*/;

	public final native void setCustomer(String customer)
	/*-{
       this["customer"] = customer;
	}-*/;

	public final native String getCustomerCode()
	/*-{
	return this["customerCode"];
	}-*/;

	public final native void setCustomerCode(String customerCode)
	/*-{
       this["customerCode"] = customerCode;
	}-*/;

	public final native String getDealer()
	/*-{
	return this["dealer"];
	}-*/;

	public final native void setDealer(String dealer)
	/*-{
       this["dealer"] = dealer;
	}-*/;

	public final native String getDistributor()
	/*-{
	return this["distributor"];
	}-*/;

	public final native void setDistributor(String distributor)
	/*-{
       this["distributor"] = distributor;
	}-*/;

	public final native net.bluemind.system.api.gwt.js.JsSubscriptionInformationsKind getKind()
	/*-{
	return this["kind"];
	}-*/;

	public final native void setKind(net.bluemind.system.api.gwt.js.JsSubscriptionInformationsKind kind)
	/*-{
       this["kind"] = kind;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getStarts()
	/*-{
       if(this["starts"]) {
          return new Date(this["starts"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setStarts(com.google.gwt.core.client.JsDate starts)
	/*-{
       this["starts"] =  ( starts != null) ? starts.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getEnds()
	/*-{
       if(this["ends"]) {
          return new Date(this["ends"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setEnds(com.google.gwt.core.client.JsDate ends)
	/*-{
       this["ends"] =  ( ends != null) ? ends.getTime() : null;
	}-*/;

	public final native boolean getValid()
	/*-{
	return this["valid"];
	}-*/;

	public final native void setValid(boolean valid)
	/*-{
       this["valid"] = valid;
	}-*/;

	public final native String getPubKeyFingerprint()
	/*-{
	return this["pubKeyFingerprint"];
	}-*/;

	public final native void setPubKeyFingerprint(String pubKeyFingerprint)
	/*-{
       this["pubKeyFingerprint"] = pubKeyFingerprint;
	}-*/;

	public final native boolean getValidProvider()
	/*-{
	return this["validProvider"];
	}-*/;

	public final native void setValidProvider(boolean validProvider)
	/*-{
       this["validProvider"] = validProvider;
	}-*/;

	public final native String getFromTechVersion()
	/*-{
	return this["fromTechVersion"];
	}-*/;

	public final native void setFromTechVersion(String fromTechVersion)
	/*-{
       this["fromTechVersion"] = fromTechVersion;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.system.api.gwt.js.JsSubscriptionInformationsInstallationIndicator> getIndicator()
	/*-{
	return this["indicator"];
	}-*/;

	public final native void setIndicator(com.google.gwt.core.client.JsArray<net.bluemind.system.api.gwt.js.JsSubscriptionInformationsInstallationIndicator> indicator)
	/*-{
       this["indicator"] = indicator;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayString getContacts()
	/*-{
	return this["contacts"];
	}-*/;

	public final native void setContacts(com.google.gwt.core.client.JsArrayString contacts)
	/*-{
       this["contacts"] = contacts;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.system.api.gwt.js.JsSubscriptionInformationsMessage> getMessages()
	/*-{
	return this["messages"];
	}-*/;

	public final native void setMessages(com.google.gwt.core.client.JsArray<net.bluemind.system.api.gwt.js.JsSubscriptionInformationsMessage> messages)
	/*-{
       this["messages"] = messages;
	}-*/;

	public static native  JsSubscriptionInformations create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}