/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VFreebusyGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VFreebusy> {

	public VFreebusyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VFreebusy deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VFreebusy ret = new net.bluemind.calendar.api.VFreebusy();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VFreebusy ret, JSONObject json) {
		JSONValue dtstartJSON = json.get("dtstart");
		ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		JSONValue dtendJSON = json.get("dtend");
		ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		JSONValue slotsJSON = json.get("slots");
		ret.slots =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VFreebusySlotGwtSerDer()).deserialize(slotsJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VFreebusy ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("dtstart")) {
			JSONValue dtstartJSON = json.get("dtstart");
			ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		}
		if (!childPropertiesToIgnore.contains("dtend")) {
			JSONValue dtendJSON = json.get("dtend");
			ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		}
		if (!childPropertiesToIgnore.contains("slots")) {
			JSONValue slotsJSON = json.get("slots");
			ret.slots =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VFreebusySlotGwtSerDer()).deserialize(slotsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VFreebusy o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VFreebusy o, JSONObject ret) {

		ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		ret.put("slots",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VFreebusySlotGwtSerDer()).serialize( o.slots ));
	}

	public void serializeTo(net.bluemind.calendar.api.VFreebusy o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("dtstart")) {
			ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		}
		if (!childPropertiesToIgnore.contains("dtend")) {
			ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		}
		if (!childPropertiesToIgnore.contains("slots")) {
			ret.put("slots",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VFreebusySlotGwtSerDer()).serialize( o.slots ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}