/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventRangeGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventRange> {

	public VEventRangeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventRange deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventRange ret = new net.bluemind.calendar.api.VEventRange();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventRange ret, JSONObject json) {
		JSONValue dateMinJSON = json.get("dateMin");
		ret.dateMin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMinJSON);
		JSONValue dateMaxJSON = json.get("dateMax");
		ret.dateMax =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMaxJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventRange ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("dateMin")) {
			JSONValue dateMinJSON = json.get("dateMin");
			ret.dateMin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMinJSON);
		}
		if (!childPropertiesToIgnore.contains("dateMax")) {
			JSONValue dateMaxJSON = json.get("dateMax");
			ret.dateMax =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMaxJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventRange o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventRange o, JSONObject ret) {

		ret.put("dateMin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMin ));
		ret.put("dateMax",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMax ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventRange o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("dateMin")) {
			ret.put("dateMin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMin ));
		}
		if (!childPropertiesToIgnore.contains("dateMax")) {
			ret.put("dateMax",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMax ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}