/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.calendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsCalendarSettingsData extends JavaScriptObject {

	protected JsCalendarSettingsData() {}

	public final native com.google.gwt.core.client.JsArray<net.bluemind.calendar.api.gwt.js.JsCalendarSettingsDataDay> getWorkingDays()
	/*-{
	return this["workingDays"];
	}-*/;

	public final native void setWorkingDays(com.google.gwt.core.client.JsArray<net.bluemind.calendar.api.gwt.js.JsCalendarSettingsDataDay> workingDays)
	/*-{
       this["workingDays"] = workingDays;
	}-*/;

	public final native Integer getDayStart()
	/*-{
	return ( this["dayStart"] != null) ? @java.lang.Integer::new(I)(this["dayStart"]) : null;
	}-*/;

	public final native void setDayStart(Integer dayStart)
	/*-{
       this["dayStart"] =  ( dayStart != null) ? dayStart.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native Integer getDayEnd()
	/*-{
	return ( this["dayEnd"] != null) ? @java.lang.Integer::new(I)(this["dayEnd"]) : null;
	}-*/;

	public final native void setDayEnd(Integer dayEnd)
	/*-{
       this["dayEnd"] =  ( dayEnd != null) ? dayEnd.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native Integer getMinDuration()
	/*-{
	return ( this["minDuration"] != null) ? @java.lang.Integer::new(I)(this["minDuration"]) : null;
	}-*/;

	public final native void setMinDuration(Integer minDuration)
	/*-{
       this["minDuration"] =  ( minDuration != null) ? minDuration.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native String getTimezoneId()
	/*-{
	return this["timezoneId"];
	}-*/;

	public final native void setTimezoneId(String timezoneId)
	/*-{
       this["timezoneId"] = timezoneId;
	}-*/;

	public static native  JsCalendarSettingsData create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}