/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SharedMailboxGwtSerDer implements GwtSerDer<net.bluemind.user.api.SharedMailbox> {

	private net.bluemind.user.api.gwt.serder.UserGwtSerDer parent = new  net.bluemind.user.api.gwt.serder.UserGwtSerDer();
	public SharedMailboxGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.SharedMailbox deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.SharedMailbox ret = new net.bluemind.user.api.SharedMailbox();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.SharedMailbox ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
	}

	public void deserializeTo(net.bluemind.user.api.SharedMailbox ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
	}


	@Override
	public JSONValue serialize(net.bluemind.user.api.SharedMailbox o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.SharedMailbox o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

	}

	public void serializeTo(net.bluemind.user.api.SharedMailbox o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}