/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserSubscriptionEndpointPromise implements net.bluemind.user.api.IUserSubscriptionPromise {

	private net.bluemind.user.api.IUserSubscriptionAsync impl;

	public UserSubscriptionEndpointPromise(net.bluemind.user.api.IUserSubscriptionAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>> listSubscriptions(String subject ,  String type  ) {
		
		CompletableFuture<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>>() {
			public void success(List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listSubscriptions(subject, type,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> subscribe(String subject ,  List<net.bluemind.core.container.api.ContainerSubscription> subscriptions  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.subscribe(subject, subscriptions,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> subscribers(String containerUid  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.subscribers(containerUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unsubscribe(String subject ,  List<String> containers  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unsubscribe(subject, containers,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateAutomount(String subject ,  List<net.bluemind.core.container.api.ContainerSubscription> subscriptions  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateAutomount(subject, subscriptions,  handler);
		return ret;
	}

}
