/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchSortSortCriteriaGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchSort.SortCriteria> {

	public SearchSortSortCriteriaGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchSort.SortCriteria deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchSort.SortCriteria ret = new net.bluemind.backend.mail.api.SearchSort.SortCriteria();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchSort.SortCriteria ret, JSONObject json) {
		JSONValue fieldJSON = json.get("field");
		ret.field =  GwtSerDerUtils.STRING.deserialize(fieldJSON);
		JSONValue orderJSON = json.get("order");
		ret.order =  new net.bluemind.backend.mail.api.gwt.serder.SearchSortOrderGwtSerDer().deserialize(orderJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchSort.SortCriteria ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("field")) {
			JSONValue fieldJSON = json.get("field");
			ret.field =  GwtSerDerUtils.STRING.deserialize(fieldJSON);
		}
		if (!childPropertiesToIgnore.contains("order")) {
			JSONValue orderJSON = json.get("order");
			ret.order =  new net.bluemind.backend.mail.api.gwt.serder.SearchSortOrderGwtSerDer().deserialize(orderJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchSort.SortCriteria o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchSort.SortCriteria o, JSONObject ret) {

		ret.put("field",  GwtSerDerUtils.STRING.serialize( o.field ));
		ret.put("order",  new net.bluemind.backend.mail.api.gwt.serder.SearchSortOrderGwtSerDer().serialize( o.order ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchSort.SortCriteria o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("field")) {
			ret.put("field",  GwtSerDerUtils.STRING.serialize( o.field ));
		}
		if (!childPropertiesToIgnore.contains("order")) {
			ret.put("order",  new net.bluemind.backend.mail.api.gwt.serder.SearchSortOrderGwtSerDer().serialize( o.order ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}