/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchResultGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchResult> {

	public SearchResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchResult ret = new net.bluemind.backend.mail.api.SearchResult();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchResult ret, JSONObject json) {
		JSONValue resultsJSON = json.get("results");
		ret.results =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultGwtSerDer()).deserialize(resultsJSON);
		JSONValue totalResultsJSON = json.get("totalResults");
		ret.totalResults =  GwtSerDerUtils.INT.deserialize(totalResultsJSON);
		JSONValue hasMoreResultsJSON = json.get("hasMoreResults");
		ret.hasMoreResults =  GwtSerDerUtils.BOOLEAN.deserialize(hasMoreResultsJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchResult ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("results")) {
			JSONValue resultsJSON = json.get("results");
			ret.results =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultGwtSerDer()).deserialize(resultsJSON);
		}
		if (!childPropertiesToIgnore.contains("totalResults")) {
			JSONValue totalResultsJSON = json.get("totalResults");
			ret.totalResults =  GwtSerDerUtils.INT.deserialize(totalResultsJSON);
		}
		if (!childPropertiesToIgnore.contains("hasMoreResults")) {
			JSONValue hasMoreResultsJSON = json.get("hasMoreResults");
			ret.hasMoreResults =  GwtSerDerUtils.BOOLEAN.deserialize(hasMoreResultsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchResult o, JSONObject ret) {

		ret.put("results",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultGwtSerDer()).serialize( o.results ));
		ret.put("totalResults",  GwtSerDerUtils.INT.serialize( o.totalResults ));
		ret.put("hasMoreResults",  GwtSerDerUtils.BOOLEAN.serialize( o.hasMoreResults ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchResult o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("results")) {
			ret.put("results",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultGwtSerDer()).serialize( o.results ));
		}
		if (!childPropertiesToIgnore.contains("totalResults")) {
			ret.put("totalResults",  GwtSerDerUtils.INT.serialize( o.totalResults ));
		}
		if (!childPropertiesToIgnore.contains("hasMoreResults")) {
			ret.put("hasMoreResults",  GwtSerDerUtils.BOOLEAN.serialize( o.hasMoreResults ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}