/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageSearchResultMboxGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageSearchResult.Mbox> {

	public MessageSearchResultMboxGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageSearchResult.Mbox deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageSearchResult.Mbox ret = new net.bluemind.backend.mail.api.MessageSearchResult.Mbox();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageSearchResult.Mbox ret, JSONObject json) {
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue addressJSON = json.get("address");
		ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		JSONValue routingTypeJSON = json.get("routingType");
		ret.routingType =  GwtSerDerUtils.STRING.deserialize(routingTypeJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageSearchResult.Mbox ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("displayName")) {
			JSONValue displayNameJSON = json.get("displayName");
			ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("address")) {
			JSONValue addressJSON = json.get("address");
			ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		}
		if (!childPropertiesToIgnore.contains("routingType")) {
			JSONValue routingTypeJSON = json.get("routingType");
			ret.routingType =  GwtSerDerUtils.STRING.deserialize(routingTypeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageSearchResult.Mbox o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageSearchResult.Mbox o, JSONObject ret) {

		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		ret.put("routingType",  GwtSerDerUtils.STRING.serialize( o.routingType ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageSearchResult.Mbox o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("displayName")) {
			ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		}
		if (!childPropertiesToIgnore.contains("address")) {
			ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		}
		if (!childPropertiesToIgnore.contains("routingType")) {
			ret.put("routingType",  GwtSerDerUtils.STRING.serialize( o.routingType ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}