/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageBodyRecipientGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageBody.Recipient> {

	public MessageBodyRecipientGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageBody.Recipient deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageBody.Recipient ret = new net.bluemind.backend.mail.api.MessageBody.Recipient();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Recipient ret, JSONObject json) {
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientKindGwtSerDer().deserialize(kindJSON);
		JSONValue addressJSON = json.get("address");
		ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		JSONValue dnJSON = json.get("dn");
		ret.dn =  GwtSerDerUtils.STRING.deserialize(dnJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Recipient ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientKindGwtSerDer().deserialize(kindJSON);
		}
		if (!childPropertiesToIgnore.contains("address")) {
			JSONValue addressJSON = json.get("address");
			ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		}
		if (!childPropertiesToIgnore.contains("dn")) {
			JSONValue dnJSON = json.get("dn");
			ret.dn =  GwtSerDerUtils.STRING.deserialize(dnJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageBody.Recipient o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Recipient o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientKindGwtSerDer().serialize( o.kind ));
		ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		ret.put("dn",  GwtSerDerUtils.STRING.serialize( o.dn ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Recipient o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientKindGwtSerDer().serialize( o.kind ));
		}
		if (!childPropertiesToIgnore.contains("address")) {
			ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		}
		if (!childPropertiesToIgnore.contains("dn")) {
			ret.put("dn",  GwtSerDerUtils.STRING.serialize( o.dn ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}