/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFinderQueryGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MailFinderQuery> {

	public MailFinderQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MailFinderQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MailFinderQuery ret = new net.bluemind.backend.mail.api.MailFinderQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailFinderQuery ret, JSONObject json) {
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue messageIdJSON = json.get("messageId");
		ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		JSONValue beforeJSON = json.get("before");
		ret.before =  GwtSerDerUtils.STRING.deserialize(beforeJSON);
		JSONValue afterJSON = json.get("after");
		ret.after =  GwtSerDerUtils.STRING.deserialize(afterJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailFinderQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("messageId")) {
			JSONValue messageIdJSON = json.get("messageId");
			ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		}
		if (!childPropertiesToIgnore.contains("before")) {
			JSONValue beforeJSON = json.get("before");
			ret.before =  GwtSerDerUtils.STRING.deserialize(beforeJSON);
		}
		if (!childPropertiesToIgnore.contains("after")) {
			JSONValue afterJSON = json.get("after");
			ret.after =  GwtSerDerUtils.STRING.deserialize(afterJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MailFinderQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailFinderQuery o, JSONObject ret) {

		ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		ret.put("before",  GwtSerDerUtils.STRING.serialize( o.before ));
		ret.put("after",  GwtSerDerUtils.STRING.serialize( o.after ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailFinderQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("messageId")) {
			ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		}
		if (!childPropertiesToIgnore.contains("before")) {
			ret.put("before",  GwtSerDerUtils.STRING.serialize( o.before ));
		}
		if (!childPropertiesToIgnore.contains("after")) {
			ret.put("after",  GwtSerDerUtils.STRING.serialize( o.after ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}