/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.domain.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DomainGwtSerDer implements GwtSerDer<net.bluemind.domain.api.Domain> {

	public DomainGwtSerDer( ) {
	}

	@Override
	public net.bluemind.domain.api.Domain deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.domain.api.Domain ret = new net.bluemind.domain.api.Domain();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.domain.api.Domain ret, JSONObject json) {
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		JSONValue globalJSON = json.get("global");
		ret.global =  GwtSerDerUtils.BOOLEAN.deserialize(globalJSON);
		JSONValue aliasesJSON = json.get("aliases");
		ret.aliases =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(aliasesJSON);
		JSONValue defaultAliasJSON = json.get("defaultAlias");
		ret.defaultAlias =  GwtSerDerUtils.STRING.deserialize(defaultAliasJSON);
	}

	public void deserializeTo(net.bluemind.domain.api.Domain ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("global")) {
			JSONValue globalJSON = json.get("global");
			ret.global =  GwtSerDerUtils.BOOLEAN.deserialize(globalJSON);
		}
		if (!childPropertiesToIgnore.contains("aliases")) {
			JSONValue aliasesJSON = json.get("aliases");
			ret.aliases =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(aliasesJSON);
		}
		if (!childPropertiesToIgnore.contains("defaultAlias")) {
			JSONValue defaultAliasJSON = json.get("defaultAlias");
			ret.defaultAlias =  GwtSerDerUtils.STRING.deserialize(defaultAliasJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.domain.api.Domain o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.domain.api.Domain o, JSONObject ret) {

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		ret.put("global",  GwtSerDerUtils.BOOLEAN.serialize( o.global ));
		ret.put("aliases",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.aliases ));
		ret.put("defaultAlias",  GwtSerDerUtils.STRING.serialize( o.defaultAlias ));
	}

	public void serializeTo(net.bluemind.domain.api.Domain o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
		if (!childPropertiesToIgnore.contains("global")) {
			ret.put("global",  GwtSerDerUtils.BOOLEAN.serialize( o.global ));
		}
		if (!childPropertiesToIgnore.contains("aliases")) {
			ret.put("aliases",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.aliases ));
		}
		if (!childPropertiesToIgnore.contains("defaultAlias")) {
			ret.put("defaultAlias",  GwtSerDerUtils.STRING.serialize( o.defaultAlias ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}