/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.group.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MemberGwtSerDer implements GwtSerDer<net.bluemind.group.api.Member> {

	public MemberGwtSerDer( ) {
	}

	@Override
	public net.bluemind.group.api.Member deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.group.api.Member ret = new net.bluemind.group.api.Member();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.group.api.Member ret, JSONObject json) {
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.group.api.gwt.serder.MemberTypeGwtSerDer().deserialize(typeJSON);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
	}

	public void deserializeTo(net.bluemind.group.api.Member ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.group.api.gwt.serder.MemberTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.group.api.Member o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.group.api.Member o, JSONObject ret) {

		ret.put("type",  new net.bluemind.group.api.gwt.serder.MemberTypeGwtSerDer().serialize( o.type ));
		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
	}

	public void serializeTo(net.bluemind.group.api.Member o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.group.api.gwt.serder.MemberTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}