/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.common.client.forms.acl;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;

import net.bluemind.core.container.model.acl.Verb;

public class AclComboDelegationList extends Composite {

	private static final AclConstants constants = GWT.create(AclConstants.class);

	private ListBox combo;
	private HashMap<String, Integer> items;

	public AclComboDelegationList(Map<String, String> values) {
		combo = new ListBox();
		items = new HashMap<String, Integer>();
		initValue(values);
		initWidget(combo);
	}

	public void setVerbs(Map<String, String> verbs) {
		combo.clear();
		items.clear();
		initValue(verbs);
	}

	public ListBox getComboList() {
		return combo;
	}

	private void initValue(Map<String, String> values) {
		if (values == null || values.size() == 0) {
			combo.addItem(constants.aclNoDelegation(), "none");
			items.put("none", items.size());

			combo.addItem(constants.aclSendAs(), "sendas");
			items.put("sendas", items.size());

			combo.addItem(constants.aclSendOnBehalf(), "sendonbehalf");
			items.put("sendonbehalf", items.size());
		} else {
			if (values.containsKey("none")) {
				combo.addItem(values.get("none"), "none");
				items.put("none", items.size());
			}
			if (values.containsKey("sendas")) {
				combo.addItem(values.get("sendas"), "sendas");
				items.put("sendas", items.size());
			}
			if (values.containsKey("sendonbehalf")) {
				combo.addItem(values.get("sendonbehalf"), "sendonbehalf");
				items.put("sendonbehalf", items.size());
			}
		}
	}

	public void setValue(Verb r) {
		if (r == Verb.SendAs) {
			combo.setSelectedIndex(items.get("sendas"));
		} else if (r == Verb.SendOnBehalf) {
			combo.setSelectedIndex(items.get("sendonbehalf"));
		} else {
			combo.setSelectedIndex(items.get("none"));
		}
	}

	public Verb getValue() {
		return getRightFromValue(combo.getValue(combo.getSelectedIndex()));
	}

	/**
	 * @param value
	 * @return
	 */
	private Verb getRightFromValue(String value) {
		Verb r = null;
		if (value.equals("sendas")) {
			r = Verb.SendAs;
		} else if (value.equals("sendonbehalf")) {
			r = Verb.SendOnBehalf;
		}
		return r;
	}

	public void setEnable(Boolean enabled) {
		combo.setEnabled(enabled);
	}

	/**
	 * @param comboValues
	 * @param rights
	 * @return
	 */
	public boolean isValidValue(Verb rights) {
		for (String value : items.keySet()) {
			if (rights.equals(getRightFromValue(value))) {
				return true;
			}
		}
		return false;
	}
}
