/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.conditions.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterRuleOperatorName extends JavaScriptObject {

	protected JsMailFilterRuleOperatorName() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailFilterRuleOperatorName EXISTS()
	/*-{
		return "EXISTS";
	}-*/;

	public static final native JsMailFilterRuleOperatorName EQUALS()
	/*-{
		return "EQUALS";
	}-*/;

	public static final native JsMailFilterRuleOperatorName CONTAINS()
	/*-{
		return "CONTAINS";
	}-*/;

	public static final native JsMailFilterRuleOperatorName MATCHES()
	/*-{
		return "MATCHES";
	}-*/;

	public static final native JsMailFilterRuleOperatorName RANGE()
	/*-{
		return "RANGE";
	}-*/;

	public static final JsMailFilterRuleOperatorName create(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleOperatorName value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case EXISTS:
				return EXISTS();
			case EQUALS:
				return EQUALS();
			case CONTAINS:
				return CONTAINS();
			case MATCHES:
				return MATCHES();
			case RANGE:
				return RANGE();
			default:
				return null;
			}
		}
	}
}