/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ShardStatsMailboxStatsGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.ShardStats.MailboxStats> {

	public ShardStatsMailboxStatsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.ShardStats.MailboxStats deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.ShardStats.MailboxStats ret = new net.bluemind.mailbox.api.ShardStats.MailboxStats();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.ShardStats.MailboxStats ret, JSONObject json) {
		JSONValue mailboxUidJSON = json.get("mailboxUid");
		ret.mailboxUid =  GwtSerDerUtils.STRING.deserialize(mailboxUidJSON);
		JSONValue aliasNameJSON = json.get("aliasName");
		ret.aliasName =  GwtSerDerUtils.STRING.deserialize(aliasNameJSON);
		JSONValue docCountJSON = json.get("docCount");
		ret.docCount =  GwtSerDerUtils.LONG.deserialize(docCountJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.ShardStats.MailboxStats ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("mailboxUid")) {
			JSONValue mailboxUidJSON = json.get("mailboxUid");
			ret.mailboxUid =  GwtSerDerUtils.STRING.deserialize(mailboxUidJSON);
		}
		if (!childPropertiesToIgnore.contains("aliasName")) {
			JSONValue aliasNameJSON = json.get("aliasName");
			ret.aliasName =  GwtSerDerUtils.STRING.deserialize(aliasNameJSON);
		}
		if (!childPropertiesToIgnore.contains("docCount")) {
			JSONValue docCountJSON = json.get("docCount");
			ret.docCount =  GwtSerDerUtils.LONG.deserialize(docCountJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.ShardStats.MailboxStats o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.ShardStats.MailboxStats o, JSONObject ret) {

		ret.put("mailboxUid",  GwtSerDerUtils.STRING.serialize( o.mailboxUid ));
		ret.put("aliasName",  GwtSerDerUtils.STRING.serialize( o.aliasName ));
		ret.put("docCount",  GwtSerDerUtils.LONG.serialize( o.docCount ));
	}

	public void serializeTo(net.bluemind.mailbox.api.ShardStats.MailboxStats o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("mailboxUid")) {
			ret.put("mailboxUid",  GwtSerDerUtils.STRING.serialize( o.mailboxUid ));
		}
		if (!childPropertiesToIgnore.contains("aliasName")) {
			ret.put("aliasName",  GwtSerDerUtils.STRING.serialize( o.aliasName ));
		}
		if (!childPropertiesToIgnore.contains("docCount")) {
			ret.put("docCount",  GwtSerDerUtils.LONG.serialize( o.docCount ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}