/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailboxesSockJsEndpoint implements net.bluemind.mailbox.api.IMailboxesAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailboxesSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mailboxes/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public MailboxesSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void addDomainRule(net.bluemind.mailbox.api.rules.MailFilterRule rule, final AsyncHandler<Long> handler) {
		String postUri = "/_rules";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().serialize( rule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Long>(handler) {
					@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void addMailboxRule(String mailboxUid, net.bluemind.mailbox.api.rules.MailFilterRule rule, final AsyncHandler<Long> handler) {
		String postUri = "/{mailboxUid}/_rules";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().serialize( rule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Long>(handler) {
					@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void addMailboxRuleRelative(String mailboxUid, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long anchorId, net.bluemind.mailbox.api.rules.MailFilterRule rule, final AsyncHandler<Long> handler) {
		String postUri = "/{mailboxUid}/_rules/{position}/{anchorId}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{position}", URL.encodePathSegment(""+position));
		postUri = postUri.replace("{anchorId}", URL.encodePathSegment(""+anchorId));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().serialize( rule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Long>(handler) {
					@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void byEmail(String email, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/_byemail";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", URL.encodeQueryString(""+email));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void byName(String name, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/_byname";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("name", URL.encodeQueryString(""+name));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void byRouting(net.bluemind.mailbox.api.Mailbox.Routing email, final AsyncHandler<List<String>> handler) {
		String postUri = "/_byRouting";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", URL.encodeQueryString(""+email));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(String uid, net.bluemind.mailbox.api.Mailbox mailbox, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer().serialize( mailbox);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void deleteDomainRule(long id, final AsyncHandler<Void> handler) {
		String postUri = "/_rules/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void deleteMailboxRule(String mailboxUid, long id, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_rules/{id}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getDomainFilter(final AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler) {
		String postUri = "/_filter";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getDomainRule(long id, final AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule> handler) {
		String postUri = "/_rules/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.rules.MailFilterRule>(handler) {
					@Override
			protected net.bluemind.mailbox.api.rules.MailFilterRule handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getDomainRules(final AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler) {
		String postUri = "/_rules";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(handler) {
					@Override
			protected List<net.bluemind.mailbox.api.rules.MailFilterRule> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxAccessControlList(String mailboxUid, final AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>> handler) {
		String postUri = "/{mailboxUid}/_acls";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.acl.AccessControlEntry>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.acl.AccessControlEntry> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxConfig(String uid, final AsyncHandler<net.bluemind.mailbox.api.MailboxConfig> handler) {
		String postUri = "/{uid}/_config";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailboxConfig>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailboxConfig handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailboxConfigGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxDelegationRule(String mailboxUid, final AsyncHandler<net.bluemind.mailbox.api.rules.DelegationRule> handler) {
		String postUri = "/{mailboxUid}/_delegationRule";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.rules.DelegationRule>(handler) {
					@Override
			protected net.bluemind.mailbox.api.rules.DelegationRule handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.rules.gwt.serder.DelegationRuleGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxFilter(String mailboxUid, final AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler) {
		String postUri = "/{mailboxUid}/_filter";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxForwarding(String mailboxUid, final AsyncHandler<net.bluemind.mailbox.api.MailFilter.Forwarding> handler) {
		String postUri = "/{mailboxUid}/_forwarding";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter.Forwarding>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter.Forwarding handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxQuota(String uid, final AsyncHandler<net.bluemind.mailbox.api.MailboxQuota> handler) {
		String postUri = "/{uid}/_quota";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailboxQuota>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailboxQuota handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailboxQuotaGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxRule(String mailboxUid, long id, final AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule> handler) {
		String postUri = "/{mailboxUid}/_rules/{id}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.rules.MailFilterRule>(handler) {
					@Override
			protected net.bluemind.mailbox.api.rules.MailFilterRule handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxRules(String mailboxUid, final AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler) {
		String postUri = "/{mailboxUid}/_rules";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(handler) {
					@Override
			protected List<net.bluemind.mailbox.api.rules.MailFilterRule> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxRulesByClient(String mailboxUid, String client, final AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler) {
		String postUri = "/{mailboxUid}/_rulesByClient";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("client", URL.encodeQueryString(""+client));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(handler) {
					@Override
			protected List<net.bluemind.mailbox.api.rules.MailFilterRule> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxVacation(String mailboxUid, final AsyncHandler<net.bluemind.mailbox.api.MailFilter.Vacation> handler) {
		String postUri = "/{mailboxUid}/_vacation";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter.Vacation>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter.Vacation handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getUnreadMessagesCount(final AsyncHandler<Integer> handler) {
		String postUri = "/_unread";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Integer>(handler) {
					@Override
			protected Integer handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.INT.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void list(final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void listUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_listUids";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void moveMailboxRule(String mailboxUid, long id, net.bluemind.mailbox.api.rules.RuleMoveDirection direction, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_rules/{id}/{direction}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		postUri = postUri.replace("{direction}", URL.encodePathSegment(""+direction));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void moveMailboxRuleRelative(String mailboxUid, long id, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long anchorId, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		postUri = postUri.replace("{position}", URL.encodePathSegment(""+position));
		postUri = postUri.replace("{anchorId}", URL.encodePathSegment(""+anchorId));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void multipleGet(List<String> uids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler) {
		String postUri = "/_mget";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setDomainFilter(net.bluemind.mailbox.api.MailFilter filter, final AsyncHandler<Void> handler) {
		String postUri = "/_filter";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxAccessControlList(String mailboxUid, List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_acls";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( accessControlEntries);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxDelegationRule(String mailboxUid, net.bluemind.mailbox.api.rules.DelegationRule delegationRule, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_delegationRule";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.DelegationRuleGwtSerDer().serialize( delegationRule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxFilter(String mailboxUid, net.bluemind.mailbox.api.MailFilter filter, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_filter";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxForwarding(String mailboxUid, net.bluemind.mailbox.api.MailFilter.Forwarding forwarding, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_forwarding";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().serialize( forwarding);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxVacation(String mailboxUid, net.bluemind.mailbox.api.MailFilter.Vacation vacation, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_vacation";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().serialize( vacation);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void update(String uid, net.bluemind.mailbox.api.Mailbox mailbox, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer().serialize( mailbox);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void updateDomainRule(long id, net.bluemind.mailbox.api.rules.MailFilterRule rule, final AsyncHandler<Void> handler) {
		String postUri = "/_rules/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().serialize( rule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void updateMailboxRule(String mailboxUid, long id, net.bluemind.mailbox.api.rules.MailFilterRule rule, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_rules/{id}";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer().serialize( rule);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.mailbox.api.IMailboxesPromise promiseApi() {
		return new MailboxesEndpointPromise(this);
	}

}
