/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailboxMgmtSockJsEndpoint implements net.bluemind.mailbox.api.IMailboxMgmtAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailboxMgmtSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mgmt/mailbox/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public MailboxMgmtSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void addIndexToRing(Integer numericIndex, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{numericIndex}/_add_index";

		postUri = postUri.replace("{numericIndex}", URL.encodePathSegment(""+numericIndex));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void consolidateDomain(final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_consolidate";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void consolidateMailbox(String mailboxUid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{mailboxUid}/_consolidate";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void deleteIndexFromRing(Integer numericIndex, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{numericIndex}/_remove_index";

		postUri = postUri.replace("{numericIndex}", URL.encodePathSegment(""+numericIndex));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getLiteStats(final AsyncHandler<List<net.bluemind.mailbox.api.SimpleShardStats>> handler) {
		String postUri = "/liteStats";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailbox.api.SimpleShardStats>>(handler) {
					@Override
			protected List<net.bluemind.mailbox.api.SimpleShardStats> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.gwt.serder.SimpleShardStatsGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getShardsStats(final AsyncHandler<List<net.bluemind.mailbox.api.ShardStats>> handler) {
		String postUri = "/shardsStats";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailbox.api.ShardStats>>(handler) {
					@Override
			protected List<net.bluemind.mailbox.api.ShardStats> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.gwt.serder.ShardStatsGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void moveIndex(String mailboxUid, String index, boolean deleteSource, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{mailboxUid}/_move_index";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("index", URL.encodeQueryString(""+index));
		params.put("deleteSource", URL.encodeQueryString(""+deleteSource));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void resetMailbox(String mailboxUid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{mailboxUid}/_reset";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void respawnMailbox(String mailboxUid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{mailboxUid}/_respawn";

		postUri = postUri.replace("{mailboxUid}", URL.encodePathSegment(""+mailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.mailbox.api.IMailboxMgmtPromise promiseApi() {
		return new MailboxMgmtEndpointPromise(this);
	}

}
