/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailshare.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailshareGwtSerDer implements GwtSerDer<net.bluemind.mailshare.api.Mailshare> {

	private net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer();
	public MailshareGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailshare.api.Mailshare deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailshare.api.Mailshare ret = new net.bluemind.mailshare.api.Mailshare();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailshare.api.Mailshare ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue quotaJSON = json.get("quota");
		ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		JSONValue routingJSON = json.get("routing");
		ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		JSONValue cardJSON = json.get("card");
		ret.card =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(cardJSON);
	}

	public void deserializeTo(net.bluemind.mailshare.api.Mailshare ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			JSONValue quotaJSON = json.get("quota");
			ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			JSONValue routingJSON = json.get("routing");
			ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		}
		if (!childPropertiesToIgnore.contains("card")) {
			JSONValue cardJSON = json.get("card");
			ret.card =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(cardJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailshare.api.Mailshare o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailshare.api.Mailshare o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		ret.put("card",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.card ));
	}

	public void serializeTo(net.bluemind.mailshare.api.Mailshare o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		}
		if (!childPropertiesToIgnore.contains("card")) {
			ret.put("card",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.card ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}