/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailshare.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailshareEndpointPromise implements net.bluemind.mailshare.api.IMailsharePromise {

	private net.bluemind.mailshare.api.IMailshareAsync impl;

	public MailshareEndpointPromise(net.bluemind.mailshare.api.IMailshareAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>> allComplete() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allComplete( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.mailshare.api.Mailshare mailshare  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, mailshare,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deletePhoto(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deletePhoto(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getIcon(String uid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIcon(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getPhoto(String uid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getPhoto(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setPhoto(String uid ,  byte[] arg1  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setPhoto(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.mailshare.api.Mailshare mailshare  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, mailshare,  handler);
		return ret;
	}

}
