/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.authentication.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsLoginResponseStatus extends JavaScriptObject {

	protected JsLoginResponseStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsLoginResponseStatus Ok()
	/*-{
		return "Ok";
	}-*/;

	public static final native JsLoginResponseStatus Bad()
	/*-{
		return "Bad";
	}-*/;

	public static final native JsLoginResponseStatus Expired()
	/*-{
		return "Expired";
	}-*/;

	public static final JsLoginResponseStatus create(net.bluemind.authentication.api.LoginResponse.Status value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Ok:
				return Ok();
			case Bad:
				return Bad();
			case Expired:
				return Expired();
			default:
				return null;
			}
		}
	}
}