/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsDPErrorDPKind extends JavaScriptObject {

	protected JsDPErrorDPKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsDPErrorDPKind ADDRESSBOOK()
	/*-{
		return "ADDRESSBOOK";
	}-*/;

	public static final native JsDPErrorDPKind CALENDAR()
	/*-{
		return "CALENDAR";
	}-*/;

	public static final native JsDPErrorDPKind USER()
	/*-{
		return "USER";
	}-*/;

	public static final native JsDPErrorDPKind MAILSHARE()
	/*-{
		return "MAILSHARE";
	}-*/;

	public static final native JsDPErrorDPKind DOMAIN_ADDRESSBOOK()
	/*-{
		return "DOMAIN_ADDRESSBOOK";
	}-*/;

	public static final native JsDPErrorDPKind DOMAIN_CALENDAR()
	/*-{
		return "DOMAIN_CALENDAR";
	}-*/;

	public static final native JsDPErrorDPKind TODOLISTS()
	/*-{
		return "TODOLISTS";
	}-*/;

	public static final native JsDPErrorDPKind WEBAPPDATA()
	/*-{
		return "WEBAPPDATA";
	}-*/;

	public static final native JsDPErrorDPKind NOTES()
	/*-{
		return "NOTES";
	}-*/;

	public static final native JsDPErrorDPKind RESOURCE()
	/*-{
		return "RESOURCE";
	}-*/;

	public static final native JsDPErrorDPKind SHARED_MAILBOX()
	/*-{
		return "SHARED_MAILBOX";
	}-*/;

	public static final JsDPErrorDPKind create(net.bluemind.dataprotect.api.DPError.DPKind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case ADDRESSBOOK:
				return ADDRESSBOOK();
			case CALENDAR:
				return CALENDAR();
			case USER:
				return USER();
			case MAILSHARE:
				return MAILSHARE();
			case DOMAIN_ADDRESSBOOK:
				return DOMAIN_ADDRESSBOOK();
			case DOMAIN_CALENDAR:
				return DOMAIN_CALENDAR();
			case TODOLISTS:
				return TODOLISTS();
			case WEBAPPDATA:
				return WEBAPPDATA();
			case NOTES:
				return NOTES();
			case RESOURCE:
				return RESOURCE();
			case SHARED_MAILBOX:
				return SHARED_MAILBOX();
			default:
				return null;
			}
		}
	}
}