/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardDeliveryAddressingGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.DeliveryAddressing> {

	public VCardDeliveryAddressingGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.DeliveryAddressing deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.DeliveryAddressing ret = new net.bluemind.addressbook.api.VCard.DeliveryAddressing();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing ret, JSONObject json) {
		JSONValue addressJSON = json.get("address");
		ret.address =  new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingAddressGwtSerDer().deserialize(addressJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("address")) {
			JSONValue addressJSON = json.get("address");
			ret.address =  new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingAddressGwtSerDer().deserialize(addressJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.DeliveryAddressing o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing o, JSONObject ret) {

		ret.put("address",  new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingAddressGwtSerDer().serialize( o.address ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("address")) {
			ret.put("address",  new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingAddressGwtSerDer().serialize( o.address ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}