/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SortDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.SortDescriptor> {

	public SortDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.SortDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.SortDescriptor ret = new net.bluemind.core.container.model.SortDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.SortDescriptor ret, JSONObject json) {
		JSONValue fieldsJSON = json.get("fields");
		ret.fields =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.SortDescriptorFieldGwtSerDer()).deserialize(fieldsJSON);
		JSONValue filterJSON = json.get("filter");
		ret.filter =  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().deserialize(filterJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.SortDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("fields")) {
			JSONValue fieldsJSON = json.get("fields");
			ret.fields =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.SortDescriptorFieldGwtSerDer()).deserialize(fieldsJSON);
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			JSONValue filterJSON = json.get("filter");
			ret.filter =  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().deserialize(filterJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.SortDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.SortDescriptor o, JSONObject ret) {

		ret.put("fields",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.SortDescriptorFieldGwtSerDer()).serialize( o.fields ));
		ret.put("filter",  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( o.filter ));
	}

	public void serializeTo(net.bluemind.core.container.model.SortDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("fields")) {
			ret.put("fields",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.SortDescriptorFieldGwtSerDer()).serialize( o.fields ));
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			ret.put("filter",  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( o.filter ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}