/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PermittedVerbsGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.PermittedVerbs> {

	public PermittedVerbsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.PermittedVerbs deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.PermittedVerbs ret = new net.bluemind.core.container.api.PermittedVerbs();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.PermittedVerbs ret, JSONObject json) {
		JSONValue verbsJSON = json.get("verbs");
		ret.verbs =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(verbsJSON);
		JSONValue canJSON = json.get("can");
		ret.can =  GwtSerDerUtils.BOOLEAN.deserialize(canJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.PermittedVerbs ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("verbs")) {
			JSONValue verbsJSON = json.get("verbs");
			ret.verbs =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(verbsJSON);
		}
		if (!childPropertiesToIgnore.contains("can")) {
			JSONValue canJSON = json.get("can");
			ret.can =  GwtSerDerUtils.BOOLEAN.deserialize(canJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.PermittedVerbs o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.PermittedVerbs o, JSONObject ret) {

		ret.put("verbs",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.verbs ));
		ret.put("can",  GwtSerDerUtils.BOOLEAN.serialize( o.can ));
	}

	public void serializeTo(net.bluemind.core.container.api.PermittedVerbs o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("verbs")) {
			ret.put("verbs",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.verbs ));
		}
		if (!childPropertiesToIgnore.contains("can")) {
			ret.put("can",  GwtSerDerUtils.BOOLEAN.serialize( o.can ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}