/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ChangesetCleanupGwtEndpoint implements net.bluemind.core.container.api.IChangesetCleanupAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ChangesetCleanupGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/changeset_cleanup/{serverUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{serverUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public ChangesetCleanupGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void deleteOldDeletedChangesetItems(int days, final AsyncHandler<Void> handler) {
		String postUri = "/_delete_old_changeset_items";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&days=" + URL.encodeQueryString(""+days);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.core.container.api.IChangesetCleanupPromise promiseApi() {
		return new ChangesetCleanupEndpointPromise(this);
	}
}
