/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SentItemGwtSerDer implements GwtSerDer<net.bluemind.eas.api.SentItem> {

	public SentItemGwtSerDer( ) {
	}

	@Override
	public net.bluemind.eas.api.SentItem deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.eas.api.SentItem ret = new net.bluemind.eas.api.SentItem();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.eas.api.SentItem ret, JSONObject json) {
		JSONValue deviceJSON = json.get("device");
		ret.device =  GwtSerDerUtils.STRING.deserialize(deviceJSON);
		JSONValue folderJSON = json.get("folder");
		ret.folder =  GwtSerDerUtils.INT.deserialize(folderJSON);
		JSONValue itemJSON = json.get("item");
		ret.item =  GwtSerDerUtils.STRING.deserialize(itemJSON);
	}

	public void deserializeTo(net.bluemind.eas.api.SentItem ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("device")) {
			JSONValue deviceJSON = json.get("device");
			ret.device =  GwtSerDerUtils.STRING.deserialize(deviceJSON);
		}
		if (!childPropertiesToIgnore.contains("folder")) {
			JSONValue folderJSON = json.get("folder");
			ret.folder =  GwtSerDerUtils.INT.deserialize(folderJSON);
		}
		if (!childPropertiesToIgnore.contains("item")) {
			JSONValue itemJSON = json.get("item");
			ret.item =  GwtSerDerUtils.STRING.deserialize(itemJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.eas.api.SentItem o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.eas.api.SentItem o, JSONObject ret) {

		ret.put("device",  GwtSerDerUtils.STRING.serialize( o.device ));
		ret.put("folder",  GwtSerDerUtils.INT.serialize( o.folder ));
		ret.put("item",  GwtSerDerUtils.STRING.serialize( o.item ));
	}

	public void serializeTo(net.bluemind.eas.api.SentItem o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("device")) {
			ret.put("device",  GwtSerDerUtils.STRING.serialize( o.device ));
		}
		if (!childPropertiesToIgnore.contains("folder")) {
			ret.put("folder",  GwtSerDerUtils.INT.serialize( o.folder ));
		}
		if (!childPropertiesToIgnore.contains("item")) {
			ret.put("item",  GwtSerDerUtils.STRING.serialize( o.item ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}