/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class EasEndpointPromise implements net.bluemind.eas.api.IEasPromise {

	private net.bluemind.eas.api.IEasAsync impl;

	public EasEndpointPromise(net.bluemind.eas.api.IEasAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> deletePendingReset(net.bluemind.eas.api.Account account  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deletePendingReset(account,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Map<String,String>> getConfiguration() {
		
		CompletableFuture<Map<String,String>> ret = new CompletableFuture<Map<String,String>>();
		AsyncHandler<Map<String,String>> handler = new AsyncHandler<Map<String,String>>() {
			public void success(Map<String,String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getConfiguration( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Map<String,String>> getFolderSyncVersions(net.bluemind.eas.api.Account account  ) {
		
		CompletableFuture<Map<String,String>> ret = new CompletableFuture<Map<String,String>>();
		AsyncHandler<Map<String,String>> handler = new AsyncHandler<Map<String,String>>() {
			public void success(Map<String,String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getFolderSyncVersions(account,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.eas.api.Heartbeat> getHeartbeat(String deviceUid  ) {
		
		CompletableFuture<net.bluemind.eas.api.Heartbeat> ret = new CompletableFuture<net.bluemind.eas.api.Heartbeat>();
		AsyncHandler<net.bluemind.eas.api.Heartbeat> handler = new AsyncHandler<net.bluemind.eas.api.Heartbeat>() {
			public void success(net.bluemind.eas.api.Heartbeat value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getHeartbeat(deviceUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> insertClientId(String clientId  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.insertClientId(clientId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> insertPendingReset(net.bluemind.eas.api.Account account  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.insertPendingReset(account,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> isKnownClientId(String clientId  ) {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.isKnownClientId(clientId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> needReset(net.bluemind.eas.api.Account account  ) {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.needReset(account,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setFolderSyncVersions(net.bluemind.eas.api.FolderSyncVersions versions  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setFolderSyncVersions(versions,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setHeartbeat(net.bluemind.eas.api.Heartbeat heartbeat  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setHeartbeat(heartbeat,  handler);
		return ret;
	}

}
