/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RestoreDefinitionGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.RestoreDefinition> {

	public RestoreDefinitionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.RestoreDefinition deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.RestoreDefinition ret = new net.bluemind.dataprotect.api.RestoreDefinition();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.RestoreDefinition ret, JSONObject json) {
		JSONValue restoreOperationIdenfitierJSON = json.get("restoreOperationIdenfitier");
		ret.restoreOperationIdenfitier =  GwtSerDerUtils.STRING.deserialize(restoreOperationIdenfitierJSON);
		JSONValue generationJSON = json.get("generation");
		ret.generation =  GwtSerDerUtils.INT.deserialize(generationJSON);
		JSONValue itemJSON = json.get("item");
		ret.item =  new net.bluemind.dataprotect.api.gwt.serder.RestorableGwtSerDer().deserialize(itemJSON);
	}

	public void deserializeTo(net.bluemind.dataprotect.api.RestoreDefinition ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("restoreOperationIdenfitier")) {
			JSONValue restoreOperationIdenfitierJSON = json.get("restoreOperationIdenfitier");
			ret.restoreOperationIdenfitier =  GwtSerDerUtils.STRING.deserialize(restoreOperationIdenfitierJSON);
		}
		if (!childPropertiesToIgnore.contains("generation")) {
			JSONValue generationJSON = json.get("generation");
			ret.generation =  GwtSerDerUtils.INT.deserialize(generationJSON);
		}
		if (!childPropertiesToIgnore.contains("item")) {
			JSONValue itemJSON = json.get("item");
			ret.item =  new net.bluemind.dataprotect.api.gwt.serder.RestorableGwtSerDer().deserialize(itemJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.RestoreDefinition o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.RestoreDefinition o, JSONObject ret) {

		ret.put("restoreOperationIdenfitier",  GwtSerDerUtils.STRING.serialize( o.restoreOperationIdenfitier ));
		ret.put("generation",  GwtSerDerUtils.INT.serialize( o.generation ));
		ret.put("item",  new net.bluemind.dataprotect.api.gwt.serder.RestorableGwtSerDer().serialize( o.item ));
	}

	public void serializeTo(net.bluemind.dataprotect.api.RestoreDefinition o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("restoreOperationIdenfitier")) {
			ret.put("restoreOperationIdenfitier",  GwtSerDerUtils.STRING.serialize( o.restoreOperationIdenfitier ));
		}
		if (!childPropertiesToIgnore.contains("generation")) {
			ret.put("generation",  GwtSerDerUtils.INT.serialize( o.generation ));
		}
		if (!childPropertiesToIgnore.contains("item")) {
			ret.put("item",  new net.bluemind.dataprotect.api.gwt.serder.RestorableGwtSerDer().serialize( o.item ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}