/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementRRuleGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.RRule> {

	public ICalendarElementRRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.RRule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.RRule ret = new net.bluemind.icalendar.api.ICalendarElement.RRule();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule ret, JSONObject json) {
		JSONValue frequencyJSON = json.get("frequency");
		ret.frequency =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().deserialize(frequencyJSON);
		JSONValue countJSON = json.get("count");
		ret.count =  GwtSerDerUtils.INT.deserialize(countJSON);
		JSONValue untilJSON = json.get("until");
		ret.until =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(untilJSON);
		JSONValue intervalJSON = json.get("interval");
		ret.interval =  GwtSerDerUtils.INT.deserialize(intervalJSON);
		JSONValue bySecondJSON = json.get("bySecond");
		ret.bySecond =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySecondJSON);
		JSONValue byMinuteJSON = json.get("byMinute");
		ret.byMinute =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMinuteJSON);
		JSONValue byHourJSON = json.get("byHour");
		ret.byHour =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byHourJSON);
		JSONValue byDayJSON = json.get("byDay");
		ret.byDay =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).deserialize(byDayJSON);
		JSONValue byMonthDayJSON = json.get("byMonthDay");
		ret.byMonthDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthDayJSON);
		JSONValue byYearDayJSON = json.get("byYearDay");
		ret.byYearDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byYearDayJSON);
		JSONValue byWeekNoJSON = json.get("byWeekNo");
		ret.byWeekNo =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byWeekNoJSON);
		JSONValue byMonthJSON = json.get("byMonth");
		ret.byMonth =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthJSON);
		JSONValue bySetPosJSON = json.get("bySetPos");
		ret.bySetPos =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySetPosJSON);
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("frequency")) {
			JSONValue frequencyJSON = json.get("frequency");
			ret.frequency =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().deserialize(frequencyJSON);
		}
		if (!childPropertiesToIgnore.contains("count")) {
			JSONValue countJSON = json.get("count");
			ret.count =  GwtSerDerUtils.INT.deserialize(countJSON);
		}
		if (!childPropertiesToIgnore.contains("until")) {
			JSONValue untilJSON = json.get("until");
			ret.until =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(untilJSON);
		}
		if (!childPropertiesToIgnore.contains("interval")) {
			JSONValue intervalJSON = json.get("interval");
			ret.interval =  GwtSerDerUtils.INT.deserialize(intervalJSON);
		}
		if (!childPropertiesToIgnore.contains("bySecond")) {
			JSONValue bySecondJSON = json.get("bySecond");
			ret.bySecond =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySecondJSON);
		}
		if (!childPropertiesToIgnore.contains("byMinute")) {
			JSONValue byMinuteJSON = json.get("byMinute");
			ret.byMinute =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMinuteJSON);
		}
		if (!childPropertiesToIgnore.contains("byHour")) {
			JSONValue byHourJSON = json.get("byHour");
			ret.byHour =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byHourJSON);
		}
		if (!childPropertiesToIgnore.contains("byDay")) {
			JSONValue byDayJSON = json.get("byDay");
			ret.byDay =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).deserialize(byDayJSON);
		}
		if (!childPropertiesToIgnore.contains("byMonthDay")) {
			JSONValue byMonthDayJSON = json.get("byMonthDay");
			ret.byMonthDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthDayJSON);
		}
		if (!childPropertiesToIgnore.contains("byYearDay")) {
			JSONValue byYearDayJSON = json.get("byYearDay");
			ret.byYearDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byYearDayJSON);
		}
		if (!childPropertiesToIgnore.contains("byWeekNo")) {
			JSONValue byWeekNoJSON = json.get("byWeekNo");
			ret.byWeekNo =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byWeekNoJSON);
		}
		if (!childPropertiesToIgnore.contains("byMonth")) {
			JSONValue byMonthJSON = json.get("byMonth");
			ret.byMonth =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthJSON);
		}
		if (!childPropertiesToIgnore.contains("bySetPos")) {
			JSONValue bySetPosJSON = json.get("bySetPos");
			ret.bySetPos =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySetPosJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.RRule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule o, JSONObject ret) {

		ret.put("frequency",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().serialize( o.frequency ));
		ret.put("count",  GwtSerDerUtils.INT.serialize( o.count ));
		ret.put("until",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.until ));
		ret.put("interval",  GwtSerDerUtils.INT.serialize( o.interval ));
		ret.put("bySecond",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySecond ));
		ret.put("byMinute",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMinute ));
		ret.put("byHour",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byHour ));
		ret.put("byDay",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).serialize( o.byDay ));
		ret.put("byMonthDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonthDay ));
		ret.put("byYearDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byYearDay ));
		ret.put("byWeekNo",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byWeekNo ));
		ret.put("byMonth",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonth ));
		ret.put("bySetPos",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySetPos ));
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("frequency")) {
			ret.put("frequency",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().serialize( o.frequency ));
		}
		if (!childPropertiesToIgnore.contains("count")) {
			ret.put("count",  GwtSerDerUtils.INT.serialize( o.count ));
		}
		if (!childPropertiesToIgnore.contains("until")) {
			ret.put("until",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.until ));
		}
		if (!childPropertiesToIgnore.contains("interval")) {
			ret.put("interval",  GwtSerDerUtils.INT.serialize( o.interval ));
		}
		if (!childPropertiesToIgnore.contains("bySecond")) {
			ret.put("bySecond",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySecond ));
		}
		if (!childPropertiesToIgnore.contains("byMinute")) {
			ret.put("byMinute",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMinute ));
		}
		if (!childPropertiesToIgnore.contains("byHour")) {
			ret.put("byHour",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byHour ));
		}
		if (!childPropertiesToIgnore.contains("byDay")) {
			ret.put("byDay",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).serialize( o.byDay ));
		}
		if (!childPropertiesToIgnore.contains("byMonthDay")) {
			ret.put("byMonthDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonthDay ));
		}
		if (!childPropertiesToIgnore.contains("byYearDay")) {
			ret.put("byYearDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byYearDay ));
		}
		if (!childPropertiesToIgnore.contains("byWeekNo")) {
			ret.put("byWeekNo",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byWeekNo ));
		}
		if (!childPropertiesToIgnore.contains("byMonth")) {
			ret.put("byMonth",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonth ));
		}
		if (!childPropertiesToIgnore.contains("bySetPos")) {
			ret.put("bySetPos",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySetPos ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}