/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementCUType extends JavaScriptObject {

	protected JsICalendarElementCUType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementCUType Individual()
	/*-{
		return "Individual";
	}-*/;

	public static final native JsICalendarElementCUType Group()
	/*-{
		return "Group";
	}-*/;

	public static final native JsICalendarElementCUType Resource()
	/*-{
		return "Resource";
	}-*/;

	public static final native JsICalendarElementCUType Room()
	/*-{
		return "Room";
	}-*/;

	public static final native JsICalendarElementCUType Unknown()
	/*-{
		return "Unknown";
	}-*/;

	public static final JsICalendarElementCUType create(net.bluemind.icalendar.api.ICalendarElement.CUType value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Individual:
				return Individual();
			case Group:
				return Group();
			case Resource:
				return Resource();
			case Room:
				return Room();
			case Unknown:
				return Unknown();
			default:
				return null;
			}
		}
	}
}