/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PrintDataGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.PrintData> {

	public PrintDataGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.PrintData deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.PrintData ret = new net.bluemind.calendar.api.PrintData();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.PrintData ret, JSONObject json) {
		JSONValue pagesJSON = json.get("pages");
		ret.pages =  GwtSerDerUtils.INT.deserialize(pagesJSON);
		JSONValue dataJSON = json.get("data");
		ret.data =  GwtSerDerUtils.STRING.deserialize(dataJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.PrintData ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("pages")) {
			JSONValue pagesJSON = json.get("pages");
			ret.pages =  GwtSerDerUtils.INT.deserialize(pagesJSON);
		}
		if (!childPropertiesToIgnore.contains("data")) {
			JSONValue dataJSON = json.get("data");
			ret.data =  GwtSerDerUtils.STRING.deserialize(dataJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.PrintData o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.PrintData o, JSONObject ret) {

		ret.put("pages",  GwtSerDerUtils.INT.serialize( o.pages ));
		ret.put("data",  GwtSerDerUtils.STRING.serialize( o.data ));
	}

	public void serializeTo(net.bluemind.calendar.api.PrintData o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("pages")) {
			ret.put("pages",  GwtSerDerUtils.INT.serialize( o.pages ));
		}
		if (!childPropertiesToIgnore.contains("data")) {
			ret.put("data",  GwtSerDerUtils.STRING.serialize( o.data ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}