/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class PublicFreebusySockJsEndpoint implements net.bluemind.calendar.api.IPublicFreebusyAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public PublicFreebusySockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars/sfreebusy";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public PublicFreebusySockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void get(String email, String callerUserUid, String callerDomain, net.bluemind.calendar.api.VFreebusyQuery query, final AsyncHandler<net.bluemind.calendar.api.VFreebusy> handler) {
		String postUri = "/{email}";

		postUri = postUri.replace("{email}", URL.encodePathSegment(""+email));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("callerUserUid", URL.encodeQueryString(""+callerUserUid));
		params.put("callerDomain", URL.encodeQueryString(""+callerDomain));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.VFreebusyQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.calendar.api.VFreebusy>(handler) {
					@Override
			protected net.bluemind.calendar.api.VFreebusy handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.calendar.api.gwt.serder.VFreebusyGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getAsString(String email, String callerUserUid, String callerDomain, net.bluemind.calendar.api.VFreebusyQuery query, final AsyncHandler<String> handler) {
		String postUri = "/{email}/_ics";

		postUri = postUri.replace("{email}", URL.encodePathSegment(""+email));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("callerUserUid", URL.encodeQueryString(""+callerUserUid));
		params.put("callerDomain", URL.encodeQueryString(""+callerDomain));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.VFreebusyQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void simple(String email, String callerUserUid, String callerDomain, final AsyncHandler<String> handler) {
		String postUri = "/{email}";

		postUri = postUri.replace("{email}", URL.encodePathSegment(""+email));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("callerUserUid", URL.encodeQueryString(""+callerUserUid));
		params.put("callerDomain", URL.encodeQueryString(""+callerDomain));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.calendar.api.IPublicFreebusyPromise promiseApi() {
		return new PublicFreebusyEndpointPromise(this);
	}

}
