/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RoleDescriptorGwtSerDer implements GwtSerDer<net.bluemind.role.api.RoleDescriptor> {

	public RoleDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.role.api.RoleDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.role.api.RoleDescriptor ret = new net.bluemind.role.api.RoleDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.role.api.RoleDescriptor ret, JSONObject json) {
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue parentRoleIdJSON = json.get("parentRoleId");
		ret.parentRoleId =  GwtSerDerUtils.STRING.deserialize(parentRoleIdJSON);
		JSONValue categoryIdJSON = json.get("categoryId");
		ret.categoryId =  GwtSerDerUtils.STRING.deserialize(categoryIdJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue selfPromoteJSON = json.get("selfPromote");
		ret.selfPromote =  GwtSerDerUtils.BOOLEAN.deserialize(selfPromoteJSON);
		JSONValue dirEntryPromoteJSON = json.get("dirEntryPromote");
		ret.dirEntryPromote =  GwtSerDerUtils.BOOLEAN.deserialize(dirEntryPromoteJSON);
		JSONValue dirEntryKindJSON = json.get("dirEntryKind");
		ret.dirEntryKind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(dirEntryKindJSON);
		JSONValue siblingRoleJSON = json.get("siblingRole");
		ret.siblingRole =  GwtSerDerUtils.STRING.deserialize(siblingRoleJSON);
		JSONValue childsRoleJSON = json.get("childsRole");
		ret.childsRole =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(childsRoleJSON);
		JSONValue visibleJSON = json.get("visible");
		ret.visible =  GwtSerDerUtils.BOOLEAN.deserialize(visibleJSON);
		JSONValue delegableJSON = json.get("delegable");
		ret.delegable =  GwtSerDerUtils.BOOLEAN.deserialize(delegableJSON);
		JSONValue containerRolesJSON = json.get("containerRoles");
		ret.containerRoles =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(containerRolesJSON);
		JSONValue priorityJSON = json.get("priority");
		ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
	}

	public void deserializeTo(net.bluemind.role.api.RoleDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("parentRoleId")) {
			JSONValue parentRoleIdJSON = json.get("parentRoleId");
			ret.parentRoleId =  GwtSerDerUtils.STRING.deserialize(parentRoleIdJSON);
		}
		if (!childPropertiesToIgnore.contains("categoryId")) {
			JSONValue categoryIdJSON = json.get("categoryId");
			ret.categoryId =  GwtSerDerUtils.STRING.deserialize(categoryIdJSON);
		}
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("selfPromote")) {
			JSONValue selfPromoteJSON = json.get("selfPromote");
			ret.selfPromote =  GwtSerDerUtils.BOOLEAN.deserialize(selfPromoteJSON);
		}
		if (!childPropertiesToIgnore.contains("dirEntryPromote")) {
			JSONValue dirEntryPromoteJSON = json.get("dirEntryPromote");
			ret.dirEntryPromote =  GwtSerDerUtils.BOOLEAN.deserialize(dirEntryPromoteJSON);
		}
		if (!childPropertiesToIgnore.contains("dirEntryKind")) {
			JSONValue dirEntryKindJSON = json.get("dirEntryKind");
			ret.dirEntryKind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(dirEntryKindJSON);
		}
		if (!childPropertiesToIgnore.contains("siblingRole")) {
			JSONValue siblingRoleJSON = json.get("siblingRole");
			ret.siblingRole =  GwtSerDerUtils.STRING.deserialize(siblingRoleJSON);
		}
		if (!childPropertiesToIgnore.contains("childsRole")) {
			JSONValue childsRoleJSON = json.get("childsRole");
			ret.childsRole =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(childsRoleJSON);
		}
		if (!childPropertiesToIgnore.contains("visible")) {
			JSONValue visibleJSON = json.get("visible");
			ret.visible =  GwtSerDerUtils.BOOLEAN.deserialize(visibleJSON);
		}
		if (!childPropertiesToIgnore.contains("delegable")) {
			JSONValue delegableJSON = json.get("delegable");
			ret.delegable =  GwtSerDerUtils.BOOLEAN.deserialize(delegableJSON);
		}
		if (!childPropertiesToIgnore.contains("containerRoles")) {
			JSONValue containerRolesJSON = json.get("containerRoles");
			ret.containerRoles =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(containerRolesJSON);
		}
		if (!childPropertiesToIgnore.contains("priority")) {
			JSONValue priorityJSON = json.get("priority");
			ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.role.api.RoleDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.role.api.RoleDescriptor o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("parentRoleId",  GwtSerDerUtils.STRING.serialize( o.parentRoleId ));
		ret.put("categoryId",  GwtSerDerUtils.STRING.serialize( o.categoryId ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("selfPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.selfPromote ));
		ret.put("dirEntryPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.dirEntryPromote ));
		ret.put("dirEntryKind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.dirEntryKind ));
		ret.put("siblingRole",  GwtSerDerUtils.STRING.serialize( o.siblingRole ));
		ret.put("childsRole",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.childsRole ));
		ret.put("visible",  GwtSerDerUtils.BOOLEAN.serialize( o.visible ));
		ret.put("delegable",  GwtSerDerUtils.BOOLEAN.serialize( o.delegable ));
		ret.put("containerRoles",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.containerRoles ));
		ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
	}

	public void serializeTo(net.bluemind.role.api.RoleDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("parentRoleId")) {
			ret.put("parentRoleId",  GwtSerDerUtils.STRING.serialize( o.parentRoleId ));
		}
		if (!childPropertiesToIgnore.contains("categoryId")) {
			ret.put("categoryId",  GwtSerDerUtils.STRING.serialize( o.categoryId ));
		}
		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("selfPromote")) {
			ret.put("selfPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.selfPromote ));
		}
		if (!childPropertiesToIgnore.contains("dirEntryPromote")) {
			ret.put("dirEntryPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.dirEntryPromote ));
		}
		if (!childPropertiesToIgnore.contains("dirEntryKind")) {
			ret.put("dirEntryKind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.dirEntryKind ));
		}
		if (!childPropertiesToIgnore.contains("siblingRole")) {
			ret.put("siblingRole",  GwtSerDerUtils.STRING.serialize( o.siblingRole ));
		}
		if (!childPropertiesToIgnore.contains("childsRole")) {
			ret.put("childsRole",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.childsRole ));
		}
		if (!childPropertiesToIgnore.contains("visible")) {
			ret.put("visible",  GwtSerDerUtils.BOOLEAN.serialize( o.visible ));
		}
		if (!childPropertiesToIgnore.contains("delegable")) {
			ret.put("delegable",  GwtSerDerUtils.BOOLEAN.serialize( o.delegable ));
		}
		if (!childPropertiesToIgnore.contains("containerRoles")) {
			ret.put("containerRoles",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.containerRoles ));
		}
		if (!childPropertiesToIgnore.contains("priority")) {
			ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}