/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class RolesGwtEndpoint implements net.bluemind.role.api.IRolesAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public RolesGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/roles";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public RolesGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getRoles(final AsyncHandler<Set<net.bluemind.role.api.RoleDescriptor>> handler) {
		String postUri = "/descriptors";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<net.bluemind.role.api.RoleDescriptor>>(handler) {
			@Override
			protected Set<net.bluemind.role.api.RoleDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.role.api.gwt.serder.RoleDescriptorGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getRolesCategories(final AsyncHandler<Set<net.bluemind.role.api.RolesCategory>> handler) {
		String postUri = "/categories";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<net.bluemind.role.api.RolesCategory>>(handler) {
			@Override
			protected Set<net.bluemind.role.api.RolesCategory> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.role.api.gwt.serder.RolesCategoryGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.role.api.IRolesPromise promiseApi() {
		return new RolesEndpointPromise(this);
	}
}
