/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.server.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ServerGwtEndpoint implements net.bluemind.server.api.IServerAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ServerGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/servers/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public ServerGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void allComplete(final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>> handler) {
		String postUri = "/_complete";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.server.api.gwt.serder.ServerGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void assign(String serverUid, String domainUid, String tag, final AsyncHandler<Void> handler) {
		String postUri = "/{domainUid}/assignments/{serverUid}/_assign";

		postUri = postUri.replace("{serverUid}", URL.encodePathSegment(""+serverUid));
		postUri = postUri.replace("{domainUid}", URL.encodePathSegment(""+domainUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&tag=" + URL.encodeQueryString(""+tag);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byAssignment(String domainUid, String tag, final AsyncHandler<List<String>> handler) {
		String postUri = "/{domainUid}/byAssignment";

		postUri = postUri.replace("{domainUid}", URL.encodePathSegment(""+domainUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&tag=" + URL.encodeQueryString(""+tag);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void create(String uid, net.bluemind.server.api.Server srv, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.server.api.gwt.serder.ServerGwtSerDer().serialize( srv);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getAssignments(String domainUid, final AsyncHandler<List<net.bluemind.server.api.Assignment>> handler) {
		String postUri = "/{domainUid}/assignments";

		postUri = postUri.replace("{domainUid}", URL.encodePathSegment(""+domainUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.server.api.Assignment>>(handler) {
			@Override
			protected List<net.bluemind.server.api.Assignment> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.server.api.gwt.serder.AssignmentGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.server.api.gwt.serder.ServerGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getServerAssignments(String uid, final AsyncHandler<List<net.bluemind.server.api.Assignment>> handler) {
		String postUri = "/{uid}/serverAssignments";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.server.api.Assignment>>(handler) {
			@Override
			protected List<net.bluemind.server.api.Assignment> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.server.api.gwt.serder.AssignmentGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getStatus(String uid, String ref, final AsyncHandler<net.bluemind.server.api.CommandStatus> handler) {
		String postUri = "/{uid}/command_status";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&ref=" + URL.encodeQueryString(""+ref);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.server.api.CommandStatus>(handler) {
			@Override
			protected net.bluemind.server.api.CommandStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.server.api.gwt.serder.CommandStatusGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void readFile(String uid, String path, final AsyncHandler<byte[]> handler) {
		String postUri = "/{uid}/fs/{path}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		postUri = postUri.replace("{path}", URL.encodePathSegment(""+path));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<byte[]>(handler) {
			@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setTags(String uid, List<String> tags, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}/tags";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( tags);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void submit(String uid, String[] argv, final AsyncHandler<String> handler) {
		String postUri = "/{uid}/submit_command";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ArraySerDer<>(GwtSerDerUtils.STRING, new String[0]).serialize( argv);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void submitAndWait(String uid, String[] argv, final AsyncHandler<net.bluemind.server.api.CommandStatus> handler) {
		String postUri = "/{uid}/submit_command_and_wait";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ArraySerDer<>(GwtSerDerUtils.STRING, new String[0]).serialize( argv);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.server.api.CommandStatus>(handler) {
			@Override
			protected net.bluemind.server.api.CommandStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.server.api.gwt.serder.CommandStatusGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void unassign(String serverUid, String domainUid, String tag, final AsyncHandler<Void> handler) {
		String postUri = "/{domainUid}/assignments/{serverUid}/_unassign";

		postUri = postUri.replace("{serverUid}", URL.encodePathSegment(""+serverUid));
		postUri = postUri.replace("{domainUid}", URL.encodePathSegment(""+domainUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&tag=" + URL.encodeQueryString(""+tag);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(String uid, net.bluemind.server.api.Server srv, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.server.api.gwt.serder.ServerGwtSerDer().serialize( srv);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void writeFile(String uid, String path, byte[] content, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/fs/{path}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		postUri = postUri.replace("{path}", URL.encodePathSegment(""+path));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ByteArraySerDer().serialize( content);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.server.api.IServerPromise promiseApi() {
		return new ServerEndpointPromise(this);
	}
}
