/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DelegationRuleGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.DelegationRule> {

	public DelegationRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.DelegationRule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.DelegationRule ret = new net.bluemind.mailbox.api.rules.DelegationRule();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.DelegationRule ret, JSONObject json) {
		JSONValue delegatorCalendarUidJSON = json.get("delegatorCalendarUid");
		ret.delegatorCalendarUid =  GwtSerDerUtils.STRING.deserialize(delegatorCalendarUidJSON);
		JSONValue delegateUidsJSON = json.get("delegateUids");
		ret.delegateUids =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(delegateUidsJSON);
		JSONValue delegatorUidJSON = json.get("delegatorUid");
		ret.delegatorUid =  GwtSerDerUtils.STRING.deserialize(delegatorUidJSON);
		JSONValue keepCopyJSON = json.get("keepCopy");
		ret.keepCopy =  GwtSerDerUtils.BOOLEAN.deserialize(keepCopyJSON);
		JSONValue readOnlyJSON = json.get("readOnly");
		ret.readOnly =  GwtSerDerUtils.BOOLEAN.deserialize(readOnlyJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.DelegationRule ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("delegatorCalendarUid")) {
			JSONValue delegatorCalendarUidJSON = json.get("delegatorCalendarUid");
			ret.delegatorCalendarUid =  GwtSerDerUtils.STRING.deserialize(delegatorCalendarUidJSON);
		}
		if (!childPropertiesToIgnore.contains("delegateUids")) {
			JSONValue delegateUidsJSON = json.get("delegateUids");
			ret.delegateUids =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(delegateUidsJSON);
		}
		if (!childPropertiesToIgnore.contains("delegatorUid")) {
			JSONValue delegatorUidJSON = json.get("delegatorUid");
			ret.delegatorUid =  GwtSerDerUtils.STRING.deserialize(delegatorUidJSON);
		}
		if (!childPropertiesToIgnore.contains("keepCopy")) {
			JSONValue keepCopyJSON = json.get("keepCopy");
			ret.keepCopy =  GwtSerDerUtils.BOOLEAN.deserialize(keepCopyJSON);
		}
		if (!childPropertiesToIgnore.contains("readOnly")) {
			JSONValue readOnlyJSON = json.get("readOnly");
			ret.readOnly =  GwtSerDerUtils.BOOLEAN.deserialize(readOnlyJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.DelegationRule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.DelegationRule o, JSONObject ret) {

		ret.put("delegatorCalendarUid",  GwtSerDerUtils.STRING.serialize( o.delegatorCalendarUid ));
		ret.put("delegateUids",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.delegateUids ));
		ret.put("delegatorUid",  GwtSerDerUtils.STRING.serialize( o.delegatorUid ));
		ret.put("keepCopy",  GwtSerDerUtils.BOOLEAN.serialize( o.keepCopy ));
		ret.put("readOnly",  GwtSerDerUtils.BOOLEAN.serialize( o.readOnly ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.DelegationRule o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("delegatorCalendarUid")) {
			ret.put("delegatorCalendarUid",  GwtSerDerUtils.STRING.serialize( o.delegatorCalendarUid ));
		}
		if (!childPropertiesToIgnore.contains("delegateUids")) {
			ret.put("delegateUids",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.delegateUids ));
		}
		if (!childPropertiesToIgnore.contains("delegatorUid")) {
			ret.put("delegatorUid",  GwtSerDerUtils.STRING.serialize( o.delegatorUid ));
		}
		if (!childPropertiesToIgnore.contains("keepCopy")) {
			ret.put("keepCopy",  GwtSerDerUtils.BOOLEAN.serialize( o.keepCopy ));
		}
		if (!childPropertiesToIgnore.contains("readOnly")) {
			ret.put("readOnly",  GwtSerDerUtils.BOOLEAN.serialize( o.readOnly ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}