/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.actions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleActionReplyGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply> {

	private net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer parent = new  net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer();
	public MailFilterRuleActionReplyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply ret = new net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue plainBodyJSON = json.get("plainBody");
		ret.plainBody =  GwtSerDerUtils.STRING.deserialize(plainBodyJSON);
		JSONValue htmlBodyJSON = json.get("htmlBody");
		ret.htmlBody =  GwtSerDerUtils.STRING.deserialize(htmlBodyJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("plainBody")) {
			JSONValue plainBodyJSON = json.get("plainBody");
			ret.plainBody =  GwtSerDerUtils.STRING.deserialize(plainBodyJSON);
		}
		if (!childPropertiesToIgnore.contains("htmlBody")) {
			JSONValue htmlBodyJSON = json.get("htmlBody");
			ret.htmlBody =  GwtSerDerUtils.STRING.deserialize(htmlBodyJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("plainBody",  GwtSerDerUtils.STRING.serialize( o.plainBody ));
		ret.put("htmlBody",  GwtSerDerUtils.STRING.serialize( o.htmlBody ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("plainBody")) {
			ret.put("plainBody",  GwtSerDerUtils.STRING.serialize( o.plainBody ));
		}
		if (!childPropertiesToIgnore.contains("htmlBody")) {
			ret.put("htmlBody",  GwtSerDerUtils.STRING.serialize( o.htmlBody ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}