/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterForwardingGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailFilter.Forwarding> {

	public MailFilterForwardingGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailFilter.Forwarding deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailFilter.Forwarding ret = new net.bluemind.mailbox.api.MailFilter.Forwarding();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter.Forwarding ret, JSONObject json) {
		JSONValue enabledJSON = json.get("enabled");
		ret.enabled =  GwtSerDerUtils.BOOLEAN.deserialize(enabledJSON);
		JSONValue localCopyJSON = json.get("localCopy");
		ret.localCopy =  GwtSerDerUtils.BOOLEAN.deserialize(localCopyJSON);
		JSONValue emailsJSON = json.get("emails");
		ret.emails =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(emailsJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter.Forwarding ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("enabled")) {
			JSONValue enabledJSON = json.get("enabled");
			ret.enabled =  GwtSerDerUtils.BOOLEAN.deserialize(enabledJSON);
		}
		if (!childPropertiesToIgnore.contains("localCopy")) {
			JSONValue localCopyJSON = json.get("localCopy");
			ret.localCopy =  GwtSerDerUtils.BOOLEAN.deserialize(localCopyJSON);
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			JSONValue emailsJSON = json.get("emails");
			ret.emails =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(emailsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailFilter.Forwarding o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter.Forwarding o, JSONObject ret) {

		ret.put("enabled",  GwtSerDerUtils.BOOLEAN.serialize( o.enabled ));
		ret.put("localCopy",  GwtSerDerUtils.BOOLEAN.serialize( o.localCopy ));
		ret.put("emails",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.emails ));
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter.Forwarding o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("enabled")) {
			ret.put("enabled",  GwtSerDerUtils.BOOLEAN.serialize( o.enabled ));
		}
		if (!childPropertiesToIgnore.contains("localCopy")) {
			ret.put("localCopy",  GwtSerDerUtils.BOOLEAN.serialize( o.localCopy ));
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			ret.put("emails",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.emails ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}