/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.videoconferencing.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VideoConferencingResourceDescriptorGwtSerDer implements GwtSerDer<net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor> {

	public VideoConferencingResourceDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor ret = new net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor ret, JSONObject json) {
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue providerJSON = json.get("provider");
		ret.provider =  GwtSerDerUtils.STRING.deserialize(providerJSON);
		JSONValue aclsJSON = json.get("acls");
		ret.acls =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize(aclsJSON);
	}

	public void deserializeTo(net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("provider")) {
			JSONValue providerJSON = json.get("provider");
			ret.provider =  GwtSerDerUtils.STRING.deserialize(providerJSON);
		}
		if (!childPropertiesToIgnore.contains("acls")) {
			JSONValue aclsJSON = json.get("acls");
			ret.acls =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize(aclsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor o, JSONObject ret) {

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("provider",  GwtSerDerUtils.STRING.serialize( o.provider ));
		ret.put("acls",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( o.acls ));
	}

	public void serializeTo(net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("provider")) {
			ret.put("provider",  GwtSerDerUtils.STRING.serialize( o.provider ));
		}
		if (!childPropertiesToIgnore.contains("acls")) {
			ret.put("acls",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( o.acls ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}