/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DirEntryQueryOrderGwtSerDer implements GwtSerDer<net.bluemind.directory.api.DirEntryQuery.Order> {

	public DirEntryQueryOrderGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.DirEntryQuery.Order deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.DirEntryQuery.Order ret = new net.bluemind.directory.api.DirEntryQuery.Order();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.DirEntryQuery.Order ret, JSONObject json) {
		JSONValue byJSON = json.get("by");
		ret.by =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderByGwtSerDer().deserialize(byJSON);
		JSONValue dirJSON = json.get("dir");
		ret.dir =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryDirGwtSerDer().deserialize(dirJSON);
	}

	public void deserializeTo(net.bluemind.directory.api.DirEntryQuery.Order ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("by")) {
			JSONValue byJSON = json.get("by");
			ret.by =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderByGwtSerDer().deserialize(byJSON);
		}
		if (!childPropertiesToIgnore.contains("dir")) {
			JSONValue dirJSON = json.get("dir");
			ret.dir =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryDirGwtSerDer().deserialize(dirJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.directory.api.DirEntryQuery.Order o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.DirEntryQuery.Order o, JSONObject ret) {

		ret.put("by",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderByGwtSerDer().serialize( o.by ));
		ret.put("dir",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryDirGwtSerDer().serialize( o.dir ));
	}

	public void serializeTo(net.bluemind.directory.api.DirEntryQuery.Order o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("by")) {
			ret.put("by",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderByGwtSerDer().serialize( o.by ));
		}
		if (!childPropertiesToIgnore.contains("dir")) {
			ret.put("dir",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryDirGwtSerDer().serialize( o.dir ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}