/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.directory.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsBaseDirEntryKind extends JavaScriptObject {

	protected JsBaseDirEntryKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsBaseDirEntryKind USER()
	/*-{
		return "USER";
	}-*/;

	public static final native JsBaseDirEntryKind GROUP()
	/*-{
		return "GROUP";
	}-*/;

	public static final native JsBaseDirEntryKind RESOURCE()
	/*-{
		return "RESOURCE";
	}-*/;

	public static final native JsBaseDirEntryKind MAILSHARE()
	/*-{
		return "MAILSHARE";
	}-*/;

	public static final native JsBaseDirEntryKind SHARED_MAILBOX()
	/*-{
		return "SHARED_MAILBOX";
	}-*/;

	public static final native JsBaseDirEntryKind CALENDAR()
	/*-{
		return "CALENDAR";
	}-*/;

	public static final native JsBaseDirEntryKind ADDRESSBOOK()
	/*-{
		return "ADDRESSBOOK";
	}-*/;

	public static final native JsBaseDirEntryKind DOMAIN()
	/*-{
		return "DOMAIN";
	}-*/;

	public static final native JsBaseDirEntryKind ORG_UNIT()
	/*-{
		return "ORG_UNIT";
	}-*/;

	public static final native JsBaseDirEntryKind EXTERNALUSER()
	/*-{
		return "EXTERNALUSER";
	}-*/;

	public static final JsBaseDirEntryKind create(net.bluemind.directory.api.BaseDirEntry.Kind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case USER:
				return USER();
			case GROUP:
				return GROUP();
			case RESOURCE:
				return RESOURCE();
			case MAILSHARE:
				return MAILSHARE();
			case SHARED_MAILBOX:
				return SHARED_MAILBOX();
			case CALENDAR:
				return CALENDAR();
			case ADDRESSBOOK:
				return ADDRESSBOOK();
			case DOMAIN:
				return DOMAIN();
			case ORG_UNIT:
				return ORG_UNIT();
			case EXTERNALUSER:
				return EXTERNALUSER();
			default:
				return null;
			}
		}
	}
}