/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class InternalAuthenticationSockJsEndpoint implements net.bluemind.authentication.api.IInternalAuthenticationAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public InternalAuthenticationSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/auth";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public InternalAuthenticationSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void backchannelLogout(Stream contentStream, final AsyncHandler<Void> handler) {
		String postUri = "/logout/backchannel";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( contentStream);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getCurrentUser(final AsyncHandler<net.bluemind.authentication.api.AuthUser> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.AuthUser>(handler) {
					@Override
			protected net.bluemind.authentication.api.AuthUser handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AuthUserGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void login(String login, String password, String origin, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/login";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		params.put("origin", URL.encodeQueryString(""+origin));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.LoginResponse>(handler) {
					@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void loginWithParams(String login, String password, String origin, Boolean interactive, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/loginWithParams";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		params.put("origin", URL.encodeQueryString(""+origin));
		params.put("interactive", URL.encodeQueryString(""+interactive));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.LoginResponse>(handler) {
					@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void logout(final AsyncHandler<Void> handler) {
		String postUri = "/logout";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void ping(final AsyncHandler<Void> handler) {
		String postUri = "/ping";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void su(String login, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/_su";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.LoginResponse>(handler) {
					@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void suWithParams(String login, Boolean interactive, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/_suWithParams";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		params.put("interactive", URL.encodeQueryString(""+interactive));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.LoginResponse>(handler) {
					@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void validate(String login, String password, String origin, final AsyncHandler<net.bluemind.authentication.api.ValidationKind> handler) {
		String postUri = "/validate";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		params.put("origin", URL.encodeQueryString(""+origin));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.ValidationKind>(handler) {
					@Override
			protected net.bluemind.authentication.api.ValidationKind handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.ValidationKindGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void validateCredentials(String login, String origin, String password, final AsyncHandler<net.bluemind.authentication.api.ValidationKind> handler) {
		String postUri = "/validatecredential";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("login", URL.encodeQueryString(""+login));
		params.put("origin", URL.encodeQueryString(""+origin));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.ValidationKind>(handler) {
					@Override
			protected net.bluemind.authentication.api.ValidationKind handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.ValidationKindGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.authentication.api.IInternalAuthenticationPromise promiseApi() {
		return new InternalAuthenticationEndpointPromise(this);
	}

}
