/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InternalAuthenticationEndpointPromise implements net.bluemind.authentication.api.IInternalAuthenticationPromise {

	private net.bluemind.authentication.api.IInternalAuthenticationAsync impl;

	public InternalAuthenticationEndpointPromise(net.bluemind.authentication.api.IInternalAuthenticationAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> backchannelLogout(Stream contentStream  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.backchannelLogout(contentStream,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.AuthUser> getCurrentUser() {
		
		CompletableFuture<net.bluemind.authentication.api.AuthUser> ret = new CompletableFuture<net.bluemind.authentication.api.AuthUser>();
		AsyncHandler<net.bluemind.authentication.api.AuthUser> handler = new AsyncHandler<net.bluemind.authentication.api.AuthUser>() {
			public void success(net.bluemind.authentication.api.AuthUser value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCurrentUser( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.LoginResponse> login(String login ,  String password ,  String origin  ) {
		
		CompletableFuture<net.bluemind.authentication.api.LoginResponse> ret = new CompletableFuture<net.bluemind.authentication.api.LoginResponse>();
		AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler = new AsyncHandler<net.bluemind.authentication.api.LoginResponse>() {
			public void success(net.bluemind.authentication.api.LoginResponse value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.login(login, password, origin,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.LoginResponse> loginWithParams(String login ,  String password ,  String origin ,  Boolean interactive  ) {
		
		CompletableFuture<net.bluemind.authentication.api.LoginResponse> ret = new CompletableFuture<net.bluemind.authentication.api.LoginResponse>();
		AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler = new AsyncHandler<net.bluemind.authentication.api.LoginResponse>() {
			public void success(net.bluemind.authentication.api.LoginResponse value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.loginWithParams(login, password, origin, interactive,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> logout() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.logout( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> ping() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.ping( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.LoginResponse> su(String login  ) {
		
		CompletableFuture<net.bluemind.authentication.api.LoginResponse> ret = new CompletableFuture<net.bluemind.authentication.api.LoginResponse>();
		AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler = new AsyncHandler<net.bluemind.authentication.api.LoginResponse>() {
			public void success(net.bluemind.authentication.api.LoginResponse value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.su(login,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.LoginResponse> suWithParams(String login ,  Boolean interactive  ) {
		
		CompletableFuture<net.bluemind.authentication.api.LoginResponse> ret = new CompletableFuture<net.bluemind.authentication.api.LoginResponse>();
		AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler = new AsyncHandler<net.bluemind.authentication.api.LoginResponse>() {
			public void success(net.bluemind.authentication.api.LoginResponse value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.suWithParams(login, interactive,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.ValidationKind> validate(String login ,  String password ,  String origin  ) {
		
		CompletableFuture<net.bluemind.authentication.api.ValidationKind> ret = new CompletableFuture<net.bluemind.authentication.api.ValidationKind>();
		AsyncHandler<net.bluemind.authentication.api.ValidationKind> handler = new AsyncHandler<net.bluemind.authentication.api.ValidationKind>() {
			public void success(net.bluemind.authentication.api.ValidationKind value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.validate(login, password, origin,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.ValidationKind> validateCredentials(String login ,  String origin ,  String password  ) {
		
		CompletableFuture<net.bluemind.authentication.api.ValidationKind> ret = new CompletableFuture<net.bluemind.authentication.api.ValidationKind>();
		AsyncHandler<net.bluemind.authentication.api.ValidationKind> handler = new AsyncHandler<net.bluemind.authentication.api.ValidationKind>() {
			public void success(net.bluemind.authentication.api.ValidationKind value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.validateCredentials(login, origin, password,  handler);
		return ret;
	}

}
