/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class SharedMailboxGwtEndpoint implements net.bluemind.user.api.ISharedMailboxAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public SharedMailboxGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/shared_mailboxes/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public SharedMailboxGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void allUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_alluids";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byEmail(String email, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler) {
		String postUri = "/byEmail/{email}";

		postUri = postUri.replace("{email}", URL.encodePathSegment(""+email));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.SharedMailboxGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byName(String login, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler) {
		String postUri = "/byName/{login}";

		postUri = postUri.replace("{login}", URL.encodePathSegment(""+login));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.SharedMailboxGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.SharedMailboxGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getLight(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler) {
		String postUri = "/{uid}/light";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.SharedMailboxGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getVCard(String uid, final AsyncHandler<net.bluemind.addressbook.api.VCard> handler) {
		String postUri = "/{uid}/vcard";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.addressbook.api.VCard>(handler) {
			@Override
			protected net.bluemind.addressbook.api.VCard handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.user.api.ISharedMailboxPromise promiseApi() {
		return new SharedMailboxEndpointPromise(this);
	}
}
