/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UpgradeReportGwtSerDer implements GwtSerDer<net.bluemind.system.api.UpgradeReport> {

	public UpgradeReportGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.UpgradeReport deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.UpgradeReport ret = new net.bluemind.system.api.UpgradeReport();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.UpgradeReport ret, JSONObject json) {
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.system.api.gwt.serder.UpgradeReportStatusGwtSerDer().deserialize(statusJSON);
		JSONValue upgradersJSON = json.get("upgraders");
		ret.upgraders =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.UpgradeReportUpgraderReportGwtSerDer()).deserialize(upgradersJSON);
	}

	public void deserializeTo(net.bluemind.system.api.UpgradeReport ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.system.api.gwt.serder.UpgradeReportStatusGwtSerDer().deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("upgraders")) {
			JSONValue upgradersJSON = json.get("upgraders");
			ret.upgraders =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.UpgradeReportUpgraderReportGwtSerDer()).deserialize(upgradersJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.UpgradeReport o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.UpgradeReport o, JSONObject ret) {

		ret.put("status",  new net.bluemind.system.api.gwt.serder.UpgradeReportStatusGwtSerDer().serialize( o.status ));
		ret.put("upgraders",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.UpgradeReportUpgraderReportGwtSerDer()).serialize( o.upgraders ));
	}

	public void serializeTo(net.bluemind.system.api.UpgradeReport o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.system.api.gwt.serder.UpgradeReportStatusGwtSerDer().serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("upgraders")) {
			ret.put("upgraders",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.UpgradeReportUpgraderReportGwtSerDer()).serialize( o.upgraders ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}