/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PublicInfosGwtSerDer implements GwtSerDer<net.bluemind.system.api.PublicInfos> {

	public PublicInfosGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.PublicInfos deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.PublicInfos ret = new net.bluemind.system.api.PublicInfos();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.PublicInfos ret, JSONObject json) {
		JSONValue defaultDomainJSON = json.get("defaultDomain");
		ret.defaultDomain =  GwtSerDerUtils.STRING.deserialize(defaultDomainJSON);
		JSONValue softwareVersionJSON = json.get("softwareVersion");
		ret.softwareVersion =  GwtSerDerUtils.STRING.deserialize(softwareVersionJSON);
		JSONValue releaseNameJSON = json.get("releaseName");
		ret.releaseName =  GwtSerDerUtils.STRING.deserialize(releaseNameJSON);
	}

	public void deserializeTo(net.bluemind.system.api.PublicInfos ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("defaultDomain")) {
			JSONValue defaultDomainJSON = json.get("defaultDomain");
			ret.defaultDomain =  GwtSerDerUtils.STRING.deserialize(defaultDomainJSON);
		}
		if (!childPropertiesToIgnore.contains("softwareVersion")) {
			JSONValue softwareVersionJSON = json.get("softwareVersion");
			ret.softwareVersion =  GwtSerDerUtils.STRING.deserialize(softwareVersionJSON);
		}
		if (!childPropertiesToIgnore.contains("releaseName")) {
			JSONValue releaseNameJSON = json.get("releaseName");
			ret.releaseName =  GwtSerDerUtils.STRING.deserialize(releaseNameJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.PublicInfos o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.PublicInfos o, JSONObject ret) {

		ret.put("defaultDomain",  GwtSerDerUtils.STRING.serialize( o.defaultDomain ));
		ret.put("softwareVersion",  GwtSerDerUtils.STRING.serialize( o.softwareVersion ));
		ret.put("releaseName",  GwtSerDerUtils.STRING.serialize( o.releaseName ));
	}

	public void serializeTo(net.bluemind.system.api.PublicInfos o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("defaultDomain")) {
			ret.put("defaultDomain",  GwtSerDerUtils.STRING.serialize( o.defaultDomain ));
		}
		if (!childPropertiesToIgnore.contains("softwareVersion")) {
			ret.put("softwareVersion",  GwtSerDerUtils.STRING.serialize( o.softwareVersion ));
		}
		if (!childPropertiesToIgnore.contains("releaseName")) {
			ret.put("releaseName",  GwtSerDerUtils.STRING.serialize( o.releaseName ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}