/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardOrganizationalOrgGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Organizational.Org> {

	public VCardOrganizationalOrgGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Organizational.Org deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Organizational.Org ret = new net.bluemind.addressbook.api.VCard.Organizational.Org();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Organizational.Org ret, JSONObject json) {
		JSONValue companyJSON = json.get("company");
		ret.company =  GwtSerDerUtils.STRING.deserialize(companyJSON);
		JSONValue divisionJSON = json.get("division");
		ret.division =  GwtSerDerUtils.STRING.deserialize(divisionJSON);
		JSONValue departmentJSON = json.get("department");
		ret.department =  GwtSerDerUtils.STRING.deserialize(departmentJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Organizational.Org ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("company")) {
			JSONValue companyJSON = json.get("company");
			ret.company =  GwtSerDerUtils.STRING.deserialize(companyJSON);
		}
		if (!childPropertiesToIgnore.contains("division")) {
			JSONValue divisionJSON = json.get("division");
			ret.division =  GwtSerDerUtils.STRING.deserialize(divisionJSON);
		}
		if (!childPropertiesToIgnore.contains("department")) {
			JSONValue departmentJSON = json.get("department");
			ret.department =  GwtSerDerUtils.STRING.deserialize(departmentJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Organizational.Org o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Organizational.Org o, JSONObject ret) {

		ret.put("company",  GwtSerDerUtils.STRING.serialize( o.company ));
		ret.put("division",  GwtSerDerUtils.STRING.serialize( o.division ));
		ret.put("department",  GwtSerDerUtils.STRING.serialize( o.department ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Organizational.Org o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("company")) {
			ret.put("company",  GwtSerDerUtils.STRING.serialize( o.company ));
		}
		if (!childPropertiesToIgnore.contains("division")) {
			ret.put("division",  GwtSerDerUtils.STRING.serialize( o.division ));
		}
		if (!childPropertiesToIgnore.contains("department")) {
			ret.put("department",  GwtSerDerUtils.STRING.serialize( o.department ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}