/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class AddressBooksMgmtSockJsEndpoint implements net.bluemind.addressbook.api.IAddressBooksMgmtAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public AddressBooksMgmtSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mgmt/addressbooks";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public AddressBooksMgmtSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void backup(String containerUid, Long since, final AsyncHandler<Stream> handler) {
		String postUri = "/{containerUid}/_backupstream";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("since", URL.encodeQueryString(""+since));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(String containerUid, net.bluemind.addressbook.api.AddressBookDescriptor descriptor, boolean isDefault, final AsyncHandler<Void> handler) {
		String postUri = "/{containerUid}";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("isDefault", URL.encodeQueryString(""+isDefault));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.addressbook.api.gwt.serder.AddressBookDescriptorGwtSerDer().serialize( descriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void delete(String containerUid, final AsyncHandler<Void> handler) {
		String postUri = "/{containerUid}";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getComplete(String containerUid, final AsyncHandler<net.bluemind.addressbook.api.AddressBookDescriptor> handler) {
		String postUri = "/{containerUid}";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.addressbook.api.AddressBookDescriptor>(handler) {
					@Override
			protected net.bluemind.addressbook.api.AddressBookDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.addressbook.api.gwt.serder.AddressBookDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void reindex(String containerUid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{containerUid}/_reindex";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void reindexAll(final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_reindex";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void reindexDomain(String domain, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_reindexDomain";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("domain", URL.encodeQueryString(""+domain));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void restore(String containerUid, Stream restoreStream, boolean reset, final AsyncHandler<Void> handler) {
		String postUri = "/{containerUid}/_restorestream";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("reset", URL.encodeQueryString(""+reset));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( restoreStream);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void update(String containerUid, net.bluemind.addressbook.api.AddressBookDescriptor descriptor, final AsyncHandler<Void> handler) {
		String postUri = "/{containerUid}";

		postUri = postUri.replace("{containerUid}", URL.encodePathSegment(""+containerUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.addressbook.api.gwt.serder.AddressBookDescriptorGwtSerDer().serialize( descriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.addressbook.api.IAddressBooksMgmtPromise promiseApi() {
		return new AddressBooksMgmtEndpointPromise(this);
	}

}
