/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.device.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsDevice extends JavaScriptObject {

	protected JsDevice() {}

	public final native String getIdentifier()
	/*-{
	return this["identifier"];
	}-*/;

	public final native void setIdentifier(String identifier)
	/*-{
       this["identifier"] = identifier;
	}-*/;

	public final native String getOwner()
	/*-{
	return this["owner"];
	}-*/;

	public final native void setOwner(String owner)
	/*-{
       this["owner"] = owner;
	}-*/;

	public final native String getType()
	/*-{
	return this["type"];
	}-*/;

	public final native void setType(String type)
	/*-{
       this["type"] = type;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getWipeDate()
	/*-{
       if(this["wipeDate"]) {
          return new Date(this["wipeDate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setWipeDate(com.google.gwt.core.client.JsDate wipeDate)
	/*-{
       this["wipeDate"] =  ( wipeDate != null) ? wipeDate.getTime() : null;
	}-*/;

	public final native String getWipeBy()
	/*-{
	return this["wipeBy"];
	}-*/;

	public final native void setWipeBy(String wipeBy)
	/*-{
       this["wipeBy"] = wipeBy;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getUnwipeDate()
	/*-{
       if(this["unwipeDate"]) {
          return new Date(this["unwipeDate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setUnwipeDate(com.google.gwt.core.client.JsDate unwipeDate)
	/*-{
       this["unwipeDate"] =  ( unwipeDate != null) ? unwipeDate.getTime() : null;
	}-*/;

	public final native String getUnwipeBy()
	/*-{
	return this["unwipeBy"];
	}-*/;

	public final native void setUnwipeBy(String unwipeBy)
	/*-{
       this["unwipeBy"] = unwipeBy;
	}-*/;

	public final native boolean getIsWiped()
	/*-{
	return this["isWiped"];
	}-*/;

	public final native void setIsWiped(boolean isWiped)
	/*-{
       this["isWiped"] = isWiped;
	}-*/;

	public final native net.bluemind.device.api.gwt.js.JsWipeMode getWipeMode()
	/*-{
	return this["wipeMode"];
	}-*/;

	public final native void setWipeMode(net.bluemind.device.api.gwt.js.JsWipeMode wipeMode)
	/*-{
       this["wipeMode"] = wipeMode;
	}-*/;

	public final native boolean getHasPartnership()
	/*-{
	return this["hasPartnership"];
	}-*/;

	public final native void setHasPartnership(boolean hasPartnership)
	/*-{
       this["hasPartnership"] = hasPartnership;
	}-*/;

	public final native Integer getPolicy()
	/*-{
	return ( this["policy"] != null) ? @java.lang.Integer::new(I)(this["policy"]) : null;
	}-*/;

	public final native void setPolicy(Integer policy)
	/*-{
       this["policy"] =  ( policy != null) ? policy.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getLastSync()
	/*-{
       if(this["lastSync"]) {
          return new Date(this["lastSync"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setLastSync(com.google.gwt.core.client.JsDate lastSync)
	/*-{
       this["lastSync"] =  ( lastSync != null) ? lastSync.getTime() : null;
	}-*/;

	public final native double getProtocolVersion()
	/*-{
	return this["protocolVersion"];
	}-*/;

	public final native void setProtocolVersion(double protocolVersion)
	/*-{
       this["protocolVersion"] = protocolVersion;
	}-*/;

	public static native  JsDevice create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}